<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require_installed();
ensure_session();

$data = read_json_body();
$name = trim((string)($data['name'] ?? ''));
if ($name === '') json_response(['ok' => false, 'error' => 'Name fehlt.'], 400);

try {
  $pdo = db();

  $stmt = $pdo->prepare("SELECT id, name, role FROM users WHERE lower(name)=lower(?) LIMIT 1");
  $stmt->execute([$name]);
  $u = $stmt->fetch();

  if (!$u) {
    $ins = $pdo->prepare("INSERT INTO users (name, role) VALUES (?, 'member')");
    $ins->execute([$name]);
    $uid = (int)$pdo->lastInsertId();
    $role = 'member';
  } else {
    $uid = (int)$u['id'];
    $role = (string)($u['role'] ?? 'member');
  }

  if ($role === 'admin') $role = 'member';

  $_SESSION['user_id'] = $uid;
  $_SESSION['user_name'] = $name;
  $_SESSION['role'] = $role;

  json_response(['ok' => true, 'user' => ['id' => $uid, 'name' => $name, 'role' => $role]]);
} catch (Throwable $e) {
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
}
